/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Arrays;
import java.util.Iterator;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Message;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGBase;
import org.xbill.DNS.SIGRecord;

public class DNSSEC {
    public static final int RSAMD5 = 1;
    public static final int RSA = 1;
    public static final int DH = 2;
    public static final int DSA = 3;
    public static final int RSASHA1 = 5;
    public static final int DSA_NSEC3_SHA1 = 6;
    public static final int RSA_NSEC3_SHA1 = 7;
    public static final int RSASHA256 = 8;
    public static final int RSASHA512 = 10;
    public static final int Failed = -1;
    public static final int Insecure = 0;
    public static final int Secure = 1;

    private DNSSEC() {
    }

    private static void digestSIG(DNSOutput dNSOutput, SIGBase sIGBase) {
        dNSOutput.writeU16(sIGBase.getTypeCovered());
        dNSOutput.writeU8(sIGBase.getAlgorithm());
        dNSOutput.writeU8(sIGBase.getLabels());
        dNSOutput.writeU32(sIGBase.getOrigTTL());
        dNSOutput.writeU32(sIGBase.getExpire().getTime() / 1000L);
        dNSOutput.writeU32(sIGBase.getTimeSigned().getTime() / 1000L);
        dNSOutput.writeU16(sIGBase.getFootprint());
        sIGBase.getSigner().toWireCanonical(dNSOutput);
    }

    public static byte[] digestRRset(RRSIGRecord rRSIGRecord, RRset rRset) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, rRSIGRecord);
        int n = rRset.size();
        Object[] objectArray = new Record[n];
        Iterator iterator = rRset.rrs();
        Name name = rRset.getName();
        Name name2 = null;
        int n2 = rRSIGRecord.getLabels() + 1;
        if (name.labels() > n2) {
            name2 = name.wild(name.labels() - n2);
        }
        while (iterator.hasNext()) {
            objectArray[--n] = (Record)iterator.next();
        }
        Arrays.sort(objectArray);
        DNSOutput dNSOutput2 = new DNSOutput();
        if (name2 != null) {
            name2.toWireCanonical(dNSOutput2);
        } else {
            name.toWireCanonical(dNSOutput2);
        }
        dNSOutput2.writeU16(rRset.getType());
        dNSOutput2.writeU16(rRset.getDClass());
        dNSOutput2.writeU32(rRSIGRecord.getOrigTTL());
        for (int i = 0; i < objectArray.length; ++i) {
            dNSOutput.writeByteArray(dNSOutput2.toByteArray());
            int n3 = dNSOutput.current();
            dNSOutput.writeU16(0);
            dNSOutput.writeByteArray(((Record)objectArray[i]).rdataToWireCanonical());
            int n4 = dNSOutput.current() - n3 - 2;
            dNSOutput.save();
            dNSOutput.jump(n3);
            dNSOutput.writeU16(n4);
            dNSOutput.restore();
        }
        return dNSOutput.toByteArray();
    }

    public static byte[] digestMessage(SIGRecord sIGRecord, Message message, byte[] byArray) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, sIGRecord);
        if (byArray != null) {
            dNSOutput.writeByteArray(byArray);
        }
        message.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    public static class Algorithm {
        public static final int RSAMD5 = 1;
        public static final int DH = 2;
        public static final int DSA = 3;
        public static final int ECC = 4;
        public static final int RSASHA1 = 5;
        public static final int DSA_NSEC3_SHA1 = 6;
        public static final int RSA_NSEC3_SHA1 = 7;
        public static final int RSASHA256 = 8;
        public static final int RSASHA512 = 10;
        public static final int INDIRECT = 252;
        public static final int PRIVATEDNS = 253;
        public static final int PRIVATEOID = 254;
        private static Mnemonic algs = new Mnemonic("DNSSEC algorithm", 2);

        private Algorithm() {
        }

        public static String string(int n) {
            return algs.getText(n);
        }

        public static int value(String string) {
            return algs.getValue(string);
        }

        static {
            algs.setMaximum(255);
            algs.setNumericAllowed(true);
            algs.add(1, "RSAMD5");
            algs.add(2, "DH");
            algs.add(3, "DSA");
            algs.add(4, "ECC");
            algs.add(5, "RSASHA1");
            algs.add(6, "DSA-NSEC3-SHA1");
            algs.add(7, "RSA-NSEC3-SHA1");
            algs.add(8, "RSASHA256");
            algs.add(10, "RSASHA512");
            algs.add(252, "INDIRECT");
            algs.add(253, "PRIVATEDNS");
            algs.add(254, "PRIVATEOID");
        }
    }
}

