/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import org.jivesoftware.smackx.jingle.SmackLogger;

public class TcpUdpBridgeClient {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(TcpUdpBridgeClient.class);
    private String remoteTcpHost = null;
    private String remoteUdpHost = null;
    private int remoteTcpPort = -1;
    private int remoteUdpPort = -1;
    private int localUdpPort = -1;
    private DatagramSocket localUdpSocket;
    private Socket localTcpSocket;

    public TcpUdpBridgeClient(String string, String string2, int n, int n2) {
        this.remoteTcpHost = string;
        this.remoteUdpHost = string2;
        this.remoteTcpPort = n;
        this.remoteUdpPort = n2;
        try {
            this.localTcpSocket = new Socket(string, n);
            this.localUdpSocket = new DatagramSocket(0);
            this.localUdpPort = this.localUdpSocket.getLocalPort();
            LOGGER.debug("UDP: " + this.localUdpSocket.getLocalPort());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.startBridge();
    }

    public void startBridge() {
        final Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    OutputStream outputStream = TcpUdpBridgeClient.this.localTcpSocket.getOutputStream();
                    while (true) {
                        byte[] byArray = new byte[500];
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, 500);
                        TcpUdpBridgeClient.this.localUdpSocket.receive(datagramPacket);
                        if (datagramPacket.getLength() == 0) continue;
                        LOGGER.debug("UDP Client Received and Sending to TCP Server:" + new String(datagramPacket.getData(), 0, datagramPacket.getLength(), "UTF-8"));
                        outputStream.write(datagramPacket.getData(), 0, datagramPacket.getLength());
                        outputStream.flush();
                        LOGGER.debug("Client Flush");
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        });
        new Thread(new Runnable(){

            public void run() {
                try {
                    InputStream inputStream = TcpUdpBridgeClient.this.localTcpSocket.getInputStream();
                    InetAddress inetAddress = InetAddress.getByName(TcpUdpBridgeClient.this.remoteUdpHost);
                    thread.start();
                    while (true) {
                        byte[] byArray = new byte[500];
                        int n = inputStream.read(byArray);
                        LOGGER.debug("TCP Client:" + new String(byArray, 0, n, "UTF-8"));
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, n);
                        datagramPacket.setAddress(inetAddress);
                        datagramPacket.setPort(TcpUdpBridgeClient.this.remoteUdpPort);
                        TcpUdpBridgeClient.this.localUdpSocket.send(datagramPacket);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    public Socket getLocalTcpSocket() {
        return this.localTcpSocket;
    }

    public DatagramSocket getLocalUdpSocket() {
        return this.localUdpSocket;
    }
}

