/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import android.os.Build;
import java.io.File;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.DNSUtil;

public class AndroidConnectionConfiguration
extends ConnectionConfiguration {
    private static final int DEFAULT_TIMEOUT = 1000;

    public AndroidConnectionConfiguration(String string) throws XMPPException {
        this.AndroidInit(string, 1000);
    }

    public AndroidConnectionConfiguration(String string, int n) throws XMPPException {
        this.AndroidInit(string, n);
    }

    public AndroidConnectionConfiguration(String string, int n, String string2) {
        super(string, n, string2);
        this.AndroidInit();
    }

    private void AndroidInit() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.setTruststoreType("AndroidCAStore");
            this.setTruststorePassword(null);
            this.setTruststorePath(null);
        } else {
            this.setTruststoreType("BKS");
            String string = System.getProperty("javax.net.ssl.trustStore");
            if (string == null) {
                string = System.getProperty("java.home") + File.separator + "etc" + File.separator + "security" + File.separator + "cacerts.bks";
            }
            this.setTruststorePath(string);
        }
    }

    private void AndroidInit(String string, int n) throws XMPPException {
        this.AndroidInit();
        class DnsSrvLookupRunnable
        implements Runnable {
            String serviceName;
            volatile DNSUtil.HostAddress address;

            public DnsSrvLookupRunnable(String string) {
                this.serviceName = string;
            }

            @Override
            public void run() {
                this.address = DNSUtil.resolveXMPPDomain(this.serviceName);
            }

            public DNSUtil.HostAddress getHostAddress() {
                return this.address;
            }
        }
        DnsSrvLookupRunnable dnsSrvLookupRunnable = new DnsSrvLookupRunnable(string);
        Thread thread = new Thread((Runnable)dnsSrvLookupRunnable, "dns-srv-lookup");
        thread.start();
        try {
            thread.join(n);
        }
        catch (InterruptedException interruptedException) {
            throw new XMPPException("DNS lookup timeout after " + n + "ms", interruptedException);
        }
        DNSUtil.HostAddress hostAddress = dnsSrvLookupRunnable.getHostAddress();
        if (hostAddress == null) {
            throw new XMPPException("DNS lookup failure");
        }
        String string2 = hostAddress.getHost();
        int n2 = hostAddress.getPort();
        ProxyInfo proxyInfo = ProxyInfo.forDefaultProxy();
        this.init(string2, n2, string, proxyInfo);
    }
}

